﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using BusinessEntities;

namespace CustomerServices
{
  public class CustomerProfile : ICustomerProfile
  {

    EntityServices.CustomerProfile _custProfile =
      new EntityServices.CustomerProfile();

    public Customer GetCustomer(string customerId)
    {
      return _custProfile.GetCustomer(customerId);
    }

    public System.Data.DataSet GetActiveCustomers()
    {
      return _custProfile.GetActiveCustomers();
    }

    public void DeleteCustomer(string customerId)
    {
      _custProfile.DeleteCustomer(customerId);
    }

    public void CreateCustomer(Customer customer)
    {
      _custProfile.SaveCustomer(customer, true);
    }

    public void UpdateCustomer(Customer customer)
    {
      _custProfile.SaveCustomer(customer, false);
    }
  }
}
